/*******************************************************************
 *
 *	File:		EMameEngine.h
 *
 *	Author:		Peter van Sebille (peter@yipton.demon.co.uk)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

#ifndef __EMAME_ENGINE_H
#define __EMAME_ENGINE_H

#include <e32std.h>
#include <e32base.h>

#include "GlobalData.h"


class MGameWatcher
{
public:
	virtual void GameFinished() = 0;
};


class CGameRunner : public CActive
{
public:
	static CGameRunner* NewLC(MGameWatcher& aGameWatcher, CMameEngine& aMameEngine);
	~CGameRunner();

	void RunGameL(TInt aGame);
	void TerminateGame();

protected:
	CGameRunner(MGameWatcher& aGameWatcher, CMameEngine& aMameEngine);
	void ConstructL();

	virtual void RunL();
	virtual void DoCancel();

	void DoRunGameL();
	static TInt ThreadMameGame(TAny* aData);
		
	MGameWatcher&		iGameWatcher;
	RThread				iThread;
	TInt				iGame;
	CMameEngine&		aMameEngine;
};


CGameRunner::CGameRunner(MGameWatcher& aGameWatcher), iGameWatcher(aGameWatcher)
{
}

CGameRunner* CGameRunner::NewLC(MGameWatcher& aGameWatcher, CMameEngine& aMameEngine)
{
	CGameRunner*	self = new(ELeave) CGameRunner(aGameWatcher, aMameEngine);
	CleanupStack::PushL(self);
	self->ConstructL();
}

void CGameRunner::ConstructL()
{
}

void CGameRunner::RunGameL(TInt aGame)
{
	TBuf<32>	threadName;

		/*
		 * Hmm, there is something funny about the game thread on target. Eventhough the
		 * previous game thread has finished (we even called Terminate on it) we cannot
		 * create a new instance of it with the same name (returns with KErrAlreadyExists).
		 * Using unique names gets round that.
		 */
	iGame = aGame;
	threadName.Format(_L("Game%d"), iGameCounter++);
	User::LeaveIfError(iThread.Create(threadName, CGameRunner::ThreadMameGame,  KGameStackSize, KGameHeapSizeMin, KGameHeapSizeMax, this, EOwnerThread));
	iThread.Resume();

	iThread.Logon(iStatus);
	SetActive();
}


void CGameRunner::DoRunGameL()
{
	iMameEngine.RunGameL(iGame);
}


void CGameRunner::TerminateGame()
{
}


class CMameEngine : public CBase
{
public:
	static CMameEngine* NewL();
	~CMameEngine();

	TGameOptions		GameOptions() {return iGameOptions;}
	void				SetGameOptions(const TGameOptions& aGameOptions){iGameOptions = aGameOptions;}
	void				SetWindowGroupId(TInt aWindowGroupId);
	void				ShutdownGame();
	struct GameDriver**	GameDrivers();
	const char*			CpuName(TInt aCpuType);
	TInt				GameNo(const TDesC& aGameName);
	TBool				IsGameCloneOf(struct GameDriver* aGame);

	void				RunGameL(TInt aGame);
protected:
	CMameEngine();
	void ConstructL();

	void DoRunGameL();
	static TInt ThreadMainEmame(TAny* aData);
	void KillRunningStdoutConsole();


	TInt			iGame;
	TInt			iGameCounter;

	TGameOptions	iGameOptions;

	RChunk			iGlobalDataChunk;
	TGlobalData*	iGlobalData;

	RThread			iMameThread;

#ifdef __WINS__
	RLibrary	iMameLib;
#endif
};


#endif			/* __EMAME_ENGINE_H */
